/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.actions;

import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.IAsnProject;
import org.asnlab.asndt.core.ISourceFolder;
import org.asnlab.asndt.internal.corext.refactoring.util.ResourceUtil;
import org.asnlab.asndt.internal.corext.util.Messages;
import org.asnlab.asndt.internal.ui.actions.ActionMessages;
import org.asnlab.asndt.internal.ui.actions.SelectionConverter;
import org.asnlab.asndt.internal.ui.asneditor.AsnEditor;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ActionUtil {
    private ActionUtil() {
    }

    public static boolean mustDisableAsnModelAction(Shell shell, Object element) {
        if (!(element instanceof ISourceFolder)) {
            return false;
        }
        IResource resource = ResourceUtil.getResource(element);
        if (resource == null || !(resource instanceof IFolder) || !resource.isLinked()) {
            return false;
        }
        MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ActionUtil_not_possible, (String)ActionMessages.ActionUtil_no_linked);
        return true;
    }

    public static boolean isProcessable(Shell shell, AsnEditor editor) {
        if (editor == null) {
            return true;
        }
        IAsnElement input = SelectionConverter.getInput(editor);
        if (input == null) {
            MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ActionUtil_notOnBuildPath_title, (String)ActionMessages.ActionUtil_notOnBuildPath_message);
            return false;
        }
        return ActionUtil.isProcessable(shell, input);
    }

    public static boolean isProcessable(Shell shell, Object element) {
        if (!(element instanceof IAsnElement)) {
            return true;
        }
        if (ActionUtil.isOnBuildPath((IAsnElement)element)) {
            return true;
        }
        MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ActionUtil_notOnBuildPath_title, (String)ActionMessages.ActionUtil_notOnBuildPath_message);
        return false;
    }

    public static boolean isOnBuildPath(IAsnElement element) {
        IProject resourceProject;
        block7: {
            IAsnProject project;
            block6: {
                if (element.getElementType() == 2) {
                    return true;
                }
                project = element.getAsnProject();
                try {
                    if (project.isOnBuildPath(element)) break block6;
                    return false;
                }
                catch (CoreException coreException) {}
            }
            resourceProject = project.getProject();
            if (resourceProject != null) break block7;
            return false;
        }
        IProjectNature nature = resourceProject.getNature("org.asnlab.asndt.core.asnnature");
        if (nature != null) {
            return true;
        }
        return false;
    }

    public static boolean areProcessable(Shell shell, IAsnElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            if (!ActionUtil.isOnBuildPath(elements[i])) {
                MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ActionUtil_notOnBuildPath_title, (String)Messages.format(ActionMessages.ActionUtil_notOnBuildPath_resource_message, new Object[]{elements[i].getPath()}));
                return false;
            }
            ++i;
        }
        return true;
    }
}

