/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.asneditor;

import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.core.dom.ASTNode;
import org.asnlab.asndt.core.dom.ASTVisitor;
import org.asnlab.asndt.core.dom.CompilationUnitDeclaration;
import org.asnlab.asndt.internal.corext.dom.Selection;
import org.asnlab.asndt.internal.corext.dom.SelectionAnalyzer;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.actions.SelectionConverter;
import org.asnlab.asndt.internal.ui.asneditor.ASTProvider;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;

public class AsnTextSelection
extends TextSelection {
    private IAsnElement fElement;
    private IAsnElement[] fResolvedElements;
    private boolean fEnclosingElementRequested;
    private IAsnElement fEnclosingElement;
    private boolean fPartialASTRequested;
    private CompilationUnitDeclaration fPartialAST;
    private boolean fNodesRequested;
    private ASTNode[] fSelectedNodes;
    private ASTNode fCoveringNode;

    public AsnTextSelection(IAsnElement element, IDocument document, int offset, int length) {
        super(document, offset, length);
        this.fElement = element;
    }

    public IAsnElement[] resolveElementAtOffset() throws AsnModelException {
        if (this.fResolvedElements != null) {
            return this.fResolvedElements;
        }
        this.fResolvedElements = SelectionConverter.codeResolve(this.fElement, (ITextSelection)this);
        return this.fResolvedElements;
    }

    public IAsnElement resolveEnclosingElement() throws AsnModelException {
        if (this.fEnclosingElementRequested) {
            return this.fEnclosingElement;
        }
        this.fEnclosingElementRequested = true;
        this.fEnclosingElement = SelectionConverter.resolveEnclosingElement(this.fElement, (ITextSelection)this);
        return this.fEnclosingElement;
    }

    public CompilationUnitDeclaration resolvePartialAstAtOffset() {
        if (this.fPartialASTRequested) {
            return this.fPartialAST;
        }
        this.fPartialASTRequested = true;
        if (!(this.fElement instanceof ICompilationUnit)) {
            return null;
        }
        this.fPartialAST = AsnPlugin.getDefault().getASTProvider().getAST(this.fElement, ASTProvider.WAIT_YES, null);
        return this.fPartialAST;
    }

    public ASTNode[] resolveSelectedNodes() {
        if (this.fNodesRequested) {
            return this.fSelectedNodes;
        }
        this.fNodesRequested = true;
        CompilationUnitDeclaration root = this.resolvePartialAstAtOffset();
        if (root == null) {
            return null;
        }
        Selection ds = Selection.createFromStartLength(this.getOffset(), this.getLength());
        SelectionAnalyzer analyzer = new SelectionAnalyzer(ds, false);
        root.accept((ASTVisitor)analyzer);
        this.fSelectedNodes = analyzer.getSelectedNodes();
        this.fCoveringNode = analyzer.getLastCoveringNode();
        return this.fSelectedNodes;
    }

    public ASTNode resolveCoveringNode() {
        if (this.fNodesRequested) {
            return this.fCoveringNode;
        }
        this.resolveSelectedNodes();
        return this.fCoveringNode;
    }
}

