/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.asneditor;

import org.asnlab.asndt.core.IAsnProject;
import org.asnlab.asndt.internal.ui.text.AsnHeuristicScanner;
import org.asnlab.asndt.internal.ui.text.AsnIndenter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ILineRange;

public final class IndentUtil {
    private static final String SLASHES = "//";

    private IndentUtil() {
    }

    public static IndentResult indentLines(IDocument document, ILineRange lines, IAsnProject project, IndentResult result) throws BadLocationException {
        int numberOfLines = lines.getNumberOfLines();
        if (numberOfLines < 1) {
            return new IndentResult(null);
        }
        result = IndentUtil.reuseOrCreateToken(result, numberOfLines);
        AsnHeuristicScanner scanner = new AsnHeuristicScanner(document);
        AsnIndenter indenter = new AsnIndenter(document, scanner, project);
        boolean changed = false;
        int tabSize = 1;
        int line = lines.getStartLine();
        int last = line + numberOfLines;
        int i = 0;
        while (line < last) {
            changed |= IndentUtil.indentLine(document, line, indenter, scanner, result.commentLinesAtColumnZero, i++, tabSize);
            ++line;
        }
        result.hasChanged = changed;
        return result;
    }

    public static IndentResult shiftLines(IDocument document, ILineRange lines, IAsnProject project, IndentResult result) throws BadLocationException {
        int numberOfLines = lines.getNumberOfLines();
        if (numberOfLines < 1) {
            return new IndentResult(null);
        }
        result = IndentUtil.reuseOrCreateToken(result, numberOfLines);
        result.hasChanged = false;
        AsnHeuristicScanner scanner = new AsnHeuristicScanner(document);
        AsnIndenter indenter = new AsnIndenter(document, scanner, project);
        String current = IndentUtil.getCurrentIndent(document, lines.getStartLine());
        StringBuffer correct = indenter.computeIndentation(document.getLineOffset(lines.getStartLine()));
        if (correct == null) {
            return result;
        }
        StringBuffer addition = new StringBuffer();
        int tabSize = 1;
        int difference = IndentUtil.subtractIndent(correct, current, addition, tabSize);
        if (difference == 0) {
            return result;
        }
        if (result.leftmostLine == -1) {
            result.leftmostLine = IndentUtil.getLeftMostLine(document, lines, tabSize);
        }
        int maxReduction = IndentUtil.computeVisualLength(IndentUtil.getCurrentIndent(document, result.leftmostLine + lines.getStartLine()), tabSize);
        if (difference > 0) {
            int line = lines.getStartLine();
            int last = line + numberOfLines;
            int i = 0;
            while (line < last) {
                IndentUtil.addIndent(document, line, addition, result.commentLinesAtColumnZero, i++);
                ++line;
            }
        } else {
            int reduction = Math.min(-difference, maxReduction);
            int line = lines.getStartLine();
            int last = line + numberOfLines;
            int i = 0;
            while (line < last) {
                IndentUtil.cutIndent(document, line, reduction, tabSize, result.commentLinesAtColumnZero, i++);
                ++line;
            }
        }
        result.hasChanged = true;
        return result;
    }

    private static void addIndent(IDocument document, int line, CharSequence indent, boolean[] commentlines, int relative) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        int insert = region.getOffset();
        int endOffset = region.getOffset() + region.getLength();
        if (!commentlines[relative]) {
            while (insert < endOffset - 2 && document.get(insert, 2).equals(SLASHES)) {
                insert += 2;
            }
        }
        document.replace(insert, 0, indent.toString());
    }

    private static void cutIndent(IDocument document, int line, int toDelete, int tabSize, boolean[] commentLines, int relative) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        int from = region.getOffset();
        int endOffset = region.getOffset() + region.getLength();
        while (from < endOffset - 2 && document.get(from, 2).equals(SLASHES)) {
            from += 2;
        }
        int to = from;
        while (toDelete > 0 && to < endOffset) {
            char ch = document.getChar(to);
            if (!Character.isWhitespace(ch) || (toDelete -= IndentUtil.computeVisualLength(ch, tabSize)) < 0) break;
            ++to;
        }
        if (endOffset > to + 1 && document.get(to, 2).equals(SLASHES)) {
            commentLines[relative] = true;
        }
        document.replace(from, to - from, null);
    }

    private static int subtractIndent(CharSequence correct, CharSequence current, StringBuffer difference, int tabSize) {
        int c2;
        int c1 = IndentUtil.computeVisualLength(correct, tabSize);
        int diff = c1 - (c2 = IndentUtil.computeVisualLength(current, tabSize));
        if (diff <= 0) {
            return diff;
        }
        difference.setLength(0);
        int len = 0;
        int i = 0;
        while (len < diff) {
            char c = correct.charAt(i++);
            difference.append(c);
            len += IndentUtil.computeVisualLength(c, tabSize);
        }
        return diff;
    }

    private static int computeVisualLength(char ch, int tabSize) {
        if (ch == '\t') {
            return tabSize;
        }
        return 1;
    }

    private static int computeVisualLength(CharSequence seq, int tablen) {
        int size = 0;
        int i = 0;
        while (i < seq.length()) {
            char ch = seq.charAt(i);
            if (ch == '\t') {
                if (tablen != 0) {
                    size += tablen - size % tablen;
                }
            } else {
                ++size;
            }
            ++i;
        }
        return size;
    }

    private static String getCurrentIndent(IDocument document, int line) throws BadLocationException {
        String type;
        IRegion region = document.getLineInformation(line);
        int from = region.getOffset();
        int endOffset = region.getOffset() + region.getLength();
        int to = from;
        while (to < endOffset - 2 && document.get(to, 2).equals(SLASHES)) {
            to += 2;
        }
        while (to < endOffset) {
            char ch = document.getChar(to);
            if (!Character.isWhitespace(ch)) break;
            ++to;
        }
        if (to > from && to < endOffset - 1 && document.get(to - 1, 2).equals(" *") && ((type = TextUtilities.getContentType((IDocument)document, (String)"___asn_partitioning", (int)to, (boolean)true)).equals("__asn_asndoc") || type.equals("__asn_multiline_comment"))) {
            --to;
        }
        return document.get(from, to - from);
    }

    private static int getLeftMostLine(IDocument document, ILineRange lines, int tabSize) throws BadLocationException {
        int numberOfLines = lines.getNumberOfLines();
        int first = lines.getStartLine();
        int minLine = -1;
        int minIndent = Integer.MAX_VALUE;
        int line = 0;
        while (line < numberOfLines) {
            int length = IndentUtil.computeVisualLength(IndentUtil.getCurrentIndent(document, line + first), tabSize);
            if (length < minIndent) {
                minIndent = length;
                minLine = line;
            }
            ++line;
        }
        return minLine;
    }

    private static IndentResult reuseOrCreateToken(IndentResult token, int numberOfLines) {
        if (token == null) {
            token = new IndentResult(new boolean[numberOfLines]);
        } else if (token.commentLinesAtColumnZero == null) {
            token.commentLinesAtColumnZero = new boolean[numberOfLines];
        } else if (token.commentLinesAtColumnZero.length != numberOfLines) {
            boolean[] commentBooleans = new boolean[numberOfLines];
            System.arraycopy(token.commentLinesAtColumnZero, 0, commentBooleans, 0, Math.min(numberOfLines, token.commentLinesAtColumnZero.length));
            token.commentLinesAtColumnZero = commentBooleans;
        }
        return token;
    }

    private static boolean indentLine(IDocument document, int line, AsnIndenter indenter, AsnHeuristicScanner scanner, boolean[] commentLines, int lineIndex, int tabSize) throws BadLocationException {
        ITypedRegion partition;
        int lineLength;
        int end;
        int offset;
        IRegion currentLine = document.getLineInformation(line);
        int wsStart = offset = currentLine.getOffset();
        String indent = null;
        if (offset < document.getLength()) {
            ITypedRegion partition2 = TextUtilities.getPartition((IDocument)document, (String)"___asn_partitioning", (int)offset, (boolean)true);
            ITypedRegion startingPartition = TextUtilities.getPartition((IDocument)document, (String)"___asn_partitioning", (int)offset, (boolean)false);
            String type = partition2.getType();
            if (type.equals("__asn_asndoc") || type.equals("__asn_multiline_comment")) {
                indent = IndentUtil.computeAsndocIndent(document, line, scanner, startingPartition);
            } else if (!commentLines[lineIndex] && startingPartition.getOffset() == offset && startingPartition.getType().equals("__asn_singleline_comment")) {
                return false;
            }
        }
        if (indent == null) {
            StringBuffer computed = indenter.computeIndentation(offset);
            indent = computed != null ? computed.toString() : new String();
        }
        if ((end = scanner.findNonWhitespaceForwardInAnyPartition(wsStart, offset + (lineLength = currentLine.getLength()))) == -1) {
            end = offset + lineLength;
        }
        int length = end - offset;
        String currentIndent = document.get(offset, length);
        if (length > 0 && (partition = TextUtilities.getPartition((IDocument)document, (String)"___asn_partitioning", (int)end, (boolean)false)).getOffset() == end && "__asn_singleline_comment".equals(partition.getType())) {
            commentLines[lineIndex] = true;
        }
        if (!indent.equals(currentIndent)) {
            document.replace(offset, length, indent);
            return true;
        }
        return false;
    }

    private static String computeAsndocIndent(IDocument document, int line, AsnHeuristicScanner scanner, ITypedRegion partition) throws BadLocationException {
        int lineLength;
        int lineEnd;
        if (line == 0) {
            return null;
        }
        IRegion lineInfo = document.getLineInformation(line);
        int lineStart = lineInfo.getOffset();
        int nonWS = scanner.findNonWhitespaceForwardInAnyPartition(lineStart, lineEnd = lineStart + (lineLength = lineInfo.getLength()));
        if (nonWS == -1 || document.getChar(nonWS) != '*') {
            if (nonWS == -1) {
                return document.get(lineStart, lineLength);
            }
            return document.get(lineStart, nonWS - lineStart);
        }
        IRegion previousLine = document.getLineInformation(line - 1);
        int previousLineStart = previousLine.getOffset();
        int previousLineLength = previousLine.getLength();
        int previousLineEnd = previousLineStart + previousLineLength;
        StringBuffer buf = new StringBuffer();
        int previousLineNonWS = scanner.findNonWhitespaceForwardInAnyPartition(previousLineStart, previousLineEnd);
        if (previousLineNonWS == -1 || document.getChar(previousLineNonWS) != '*') {
            previousLine = document.getLineInformationOfOffset(partition.getOffset());
            previousLineStart = previousLine.getOffset();
            previousLineNonWS = scanner.findNonWhitespaceForwardInAnyPartition(previousLineStart, previousLineEnd = previousLineStart + (previousLineLength = previousLine.getLength()));
            if (previousLineNonWS == -1) {
                previousLineNonWS = previousLineEnd;
            }
            buf.append(' ');
        }
        String indentation = document.get(previousLineStart, previousLineNonWS - previousLineStart);
        buf.insert(0, indentation);
        return buf.toString();
    }

    public static final class IndentResult {
        private boolean[] commentLinesAtColumnZero;
        private boolean hasChanged;
        private int leftmostLine = -1;

        private IndentResult(boolean[] commentLines) {
            this.commentLinesAtColumnZero = commentLines;
        }

        public boolean hasChanged() {
            return this.hasChanged;
        }
    }
}

