/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.search;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.internal.corext.util.Messages;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.search.LRUWorkingSetsList;
import org.asnlab.asndt.internal.ui.search.SearchMessages;
import org.asnlab.asndt.internal.ui.search.WorkingSetComparator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class SearchUtil {
    public static final int LRU_WORKINGSET_LIST_SIZE = 3;
    private static LRUWorkingSetsList fgLRUWorkingSets;
    private static final String DIALOG_SETTINGS_KEY = "AsnElementSearchActions";
    private static final String STORE_LRU_WORKING_SET_NAMES = "lastUsedWorkingSetNames";
    private static final String BIN_PRIM_CONST_WARN_DIALOG_ID = "BinaryPrimitiveConstantWarningDialog";

    public static boolean isSearchPlugInActivated() {
        return Platform.getBundle((String)"org.eclipse.search").getState() == 32;
    }

    public static void runQueryInBackground(Object query) {
        NewSearchUI.runQueryInBackground((ISearchQuery)((ISearchQuery)query));
    }

    public static IStatus runQueryInForeground(IRunnableContext context, Object query) {
        return NewSearchUI.runQueryInForeground((IRunnableContext)context, (ISearchQuery)((ISearchQuery)query));
    }

    static ICompilationUnit findCompilationUnit(IAsnElement element) {
        if (element == null) {
            return null;
        }
        return (ICompilationUnit)element.getAncestor(5);
    }

    public static String toString(IWorkingSet[] workingSets) {
        Arrays.sort(workingSets, new WorkingSetComparator());
        String result = "";
        if (workingSets != null && workingSets.length > 0) {
            boolean firstFound = false;
            int i = 0;
            while (i < workingSets.length) {
                String workingSetLabel = workingSets[i].getLabel();
                if (firstFound) {
                    result = Messages.format(SearchMessages.SearchUtil_workingSetConcatenation, new String[]{result, workingSetLabel});
                } else {
                    result = workingSetLabel;
                    firstFound = true;
                }
                ++i;
            }
        }
        return result;
    }

    public static void updateLRUWorkingSets(IWorkingSet[] workingSets) {
        if (workingSets == null || workingSets.length < 1) {
            return;
        }
        SearchUtil.getLRUWorkingSets().add(workingSets);
        SearchUtil.saveState(SearchUtil.getDialogStoreSection());
    }

    private static void saveState(IDialogSettings settingsStore) {
        Iterator iter = fgLRUWorkingSets.iterator();
        int i = 0;
        while (iter.hasNext()) {
            IWorkingSet[] workingSets = (IWorkingSet[])iter.next();
            String[] names = new String[workingSets.length];
            int j = 0;
            while (j < workingSets.length) {
                names[j] = workingSets[j].getName();
                ++j;
            }
            settingsStore.put(STORE_LRU_WORKING_SET_NAMES + i, names);
            ++i;
        }
    }

    public static LRUWorkingSetsList getLRUWorkingSets() {
        if (fgLRUWorkingSets == null) {
            SearchUtil.restoreState();
        }
        return fgLRUWorkingSets;
    }

    private static void restoreState() {
        fgLRUWorkingSets = new LRUWorkingSetsList(3);
        IDialogSettings settingsStore = SearchUtil.getDialogStoreSection();
        boolean foundLRU = false;
        int i = 2;
        while (i >= 0) {
            String[] lruWorkingSetNames = settingsStore.getArray(STORE_LRU_WORKING_SET_NAMES + i);
            if (lruWorkingSetNames != null) {
                HashSet<IWorkingSet> workingSets = new HashSet<IWorkingSet>(2);
                int j = 0;
                while (j < lruWorkingSetNames.length) {
                    IWorkingSet workingSet = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(lruWorkingSetNames[j]);
                    if (workingSet != null) {
                        workingSets.add(workingSet);
                    }
                    ++j;
                }
                foundLRU = true;
                if (!workingSets.isEmpty()) {
                    fgLRUWorkingSets.add(workingSets.toArray(new IWorkingSet[workingSets.size()]));
                }
            }
            --i;
        }
        if (!foundLRU) {
            SearchUtil.restoreFromOldFormat();
        }
    }

    private static IDialogSettings getDialogStoreSection() {
        IDialogSettings settingsStore = AsnPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_KEY);
        if (settingsStore == null) {
            settingsStore = AsnPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS_KEY);
        }
        return settingsStore;
    }

    private static void restoreFromOldFormat() {
        fgLRUWorkingSets = new LRUWorkingSetsList(3);
        IDialogSettings settingsStore = SearchUtil.getDialogStoreSection();
        boolean foundLRU = false;
        String[] lruWorkingSetNames = settingsStore.getArray(STORE_LRU_WORKING_SET_NAMES);
        if (lruWorkingSetNames != null) {
            int i = lruWorkingSetNames.length - 1;
            while (i >= 0) {
                IWorkingSet workingSet = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(lruWorkingSetNames[i]);
                if (workingSet != null) {
                    foundLRU = true;
                    fgLRUWorkingSets.add(new IWorkingSet[]{workingSet});
                }
                --i;
            }
        }
        if (foundLRU) {
            SearchUtil.saveState(settingsStore);
        }
    }
}

